<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UsersController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

//Route::resource('/kategoriWeb', 'KasirApi@kategoriWeb');

// Route::resource('/absen', 'AbsenController', ['names'=>'absen']);


      Route::post('/login_sanctum', [UsersController::class, 'login_sanctum'])->name('login_sanctum');
      Route::post('/logout', 'UsersController@logout');
      Route::post('/delete_kategori', 'KasirApi@delete_kategori');
      Route::post('/save_sync', 'KasirApi@save_sync');
      Route::post('/show_user', 'KasirApi@show_user');
      Route::post('/register', 'UsersController@register');
      Route::post('/userList', 'UsersController@userList');
      Route::post('/save_kategori', 'KasirApi@save_kategori');
      Route::get('/show_kategori', 'KasirApi@show_kategori');
      Route::post('/sendOtp', 'UsersController@sendOtp');
      Route::post('/verifyOtp', 'UsersController@verifyOtp');




     Route::middleware(['auth:sanctum'])->group(function () {

        Route::post('/add_kategori', 'KasirApi@add_kategori');
        Route::get('/kategori', 'KasirApi@kategori');
        Route::get('/penerimaan', 'KasirApi@penerimaan');
        Route::get('/pengeluaran', 'KasirApi@pengeluaran');
        Route::get('/produkRestore', 'KasirApi@produkRestore');
        Route::get('/profil', 'KasirApi@profil');
        Route::get('/produkSync', 'KasirApi@produkSync');
        Route::get('/updateProdukSync/{id}', 'KasirApi@updateProdukSync');
        Route::get('/penerimaanPengeluaranLaporan/{tanggal}', 'KasirApi@penerimaanPengeluaranLaporan');
        Route::get('/penerimaanPengeluaranLaporanBulanan/{tanggal}', 'KasirApi@penerimaanPengeluaranLaporanBulanan');
        Route::get('/laporan_today/{tanggal}/{status}', 'KasirApi@laporan_today');
        Route::get('/list_laporan_today/{tanggal}/{status}', 'KasirApi@list_laporan_today');
        Route::get('/penjualan_terbanyak/{bulan}', 'KasirApi@penjualan_terbanyak');
        Route::get('/laporan_admin/{tanggal}', 'KasirApi@laporan_admin');
        Route::get('/laporan_bulanan/{bulan}/{status}', 'KasirApi@laporan_bulanan');
        Route::get('/list_laporan_bulanan/{bulan}/{status}', 'KasirApi@list_laporan_bulanan');
        Route::post('/createPengeluaran', 'KasirApi@createPengeluaran');
        Route::post('/createPenerimaan', 'KasirApi@createPenerimaan');
        Route::get('/get_client_ip', 'KasirApi@get_client_ip');
        Route::post('/add_produk', 'KasirApi@add_produk');
        Route::post('/save_detail_trans_pembelian', 'KasirApi@save_detail_trans_pembelian');
        Route::post('/save_pembayaran', 'KasirApi@save_pembayaran');
        Route::post('/add_produk_mobile', 'KasirApi@add_produk_mobile');
        Route::post('/update_produk_mobile', 'KasirApi@add_produk_mobile');
        Route::resource('/kategoriWeb', 'KasirApi', ['names'=>'kategoriWeb']);
        Route::post('/update_kategori', 'KasirApi@update_kategori');
        Route::post('/update_produk', 'KasirApi@update_produk');
        Route::post('/save_sync_kategori', 'KasirApi@save_sync_kategori');
        Route::post('/delete_kategori', 'KasirApi@delete_kategori');
        Route::post('/delete_penerimaan', 'KasirApi@delete_penerimaan');
        Route::post('/delete_pengeluaran', 'KasirApi@delete_pengeluaran');

        Route::get('/delete_produk/{id}', 'KasirApi@delete_produk');
        Route::get('/produk', 'KasirApi@produk');
        Route::post('/save_transaksi_pembelian_sync', 'KasirApi@save_transaksi_pembelian_sync');
        Route::post('/save_detail_trans_pembelian_sync', 'KasirApi@save_detail_trans_pembelian_sync');
        Route::post('/save_pembayaran_sync', 'KasirApi@save_pembayaran_sync');
        Route::post('/getTanggalTransaksi', 'KasirApi@getTanggalTransaksi');
        Route::get('/last_produk_id', 'KasirApi@last_produk_id');
        Route::get('/laporan_tahunan/{tahun}/{status}', 'KasirApi@laporan_tahunan');
        Route::get('/list_laporan_tahunan/{tahun}/{status}', 'KasirApi@list_laporan_tahunan');
        Route::get('/penerimaanPengeluaranLaporanTahunan/{tahun}', 'KasirApi@penerimaanPengeluaranLaporanTahunan');
        Route::post('/save_pemesanan_didepan', 'KasirApi@save_pemesanan_didepan');
        Route::post('/truncate_pemesanan', 'KasirApi@truncate_pemesanan');
        Route::post('/truncate_in_out', 'KasirApi@truncate_in_out');
        Route::post('/save_pembayaran_didepan', 'KasirApi@save_pembayaran_didepan');
        Route::post('/edit_detail_transaksi_pembelian', 'KasirApi@edit_detail_transaksi_pembelian');
        Route::post('/delete_detail_transaksi', 'KasirApi@delete_detail_transaksi');
        Route::post('/delete_detail_transaksi_pemesanan', 'KasirApi@delete_detail_transaksi_pemesanan');
        Route::post('/split_trans', 'KasirApi@split_trans');
        Route::post('/save_jurnal', 'KasirApi@save_jurnal');
        Route::get('/transaksiJurnal/{tanggal}/{status}', 'KasirApi@transaksiJurnal');
        Route::get('/cekSaldo/{tanggal}', 'KasirApi@cekSaldo');
        Route::get('/totTransaksi/{tanggal}/{status}', 'KasirApi@totTransaksi');
        Route::get('/transaksiJurnalPerBulan/{tanggal}', 'KasirApi@transaksiJurnalPerBulan');
        Route::post('/update_penerimaan', 'KasirApi@update_penerimaan');
        Route::post('/update_pengeluaran', 'KasirApi@update_pengeluaran');
        Route::post('/cekKode', 'KasirApi@cekKode');
        Route::get('/test/{tanggal}', 'KasirApi@test');
        Route::get('/jam_kerja', 'KasirApi@jam_kerja');
        Route::post('/update_jam_kerja', 'KasirApi@update_jam_kerja');
        Route::post('/tambah_jam_kerja', 'KasirApi@tambah_jam_kerja');
        Route::post('/ubahHarga', 'KasirApi@ubahHarga');
        Route::post('/truncate_produk', 'KasirApi@truncate_produk');
        Route::post('/simpanSubDetail', 'KasirApi@simpanSubDetail');
        Route::post('/split_sub_trans', 'KasirApi@split_sub_trans');
        Route::get('/pelanggan', 'KasirApi@pelanggan');
        Route::post('/simpanPelanggan', 'KasirApi@simpanPelanggan');
        Route::post('/updatePelanggan', 'KasirApi@updatePelanggan');
        Route::post('/destroyPelanggan', 'KasirApi@destroyPelanggan');
        Route::post('/save_hutang', 'KasirApi@save_hutang');
        Route::post('/pengembalian', 'KasirApi@pengembalian');








      } );
