<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Laravel\Sanctum\HasApiTokens;


class Pengembalian extends Model
{
    use HasFactory;
    use HasApiTokens;
    public $timestamps = true;


    protected $table = 'tb_pengembalian';

    protected $fillable = [
        'kode',
        'id_transaksi',
        'id_pelanggan',
        'total',
        'keterangan',
       
    ];

    // Relasi: 1 pengembalian memiliki banyak detail
    public function detailPengembalian()
    {
        return $this->hasMany(DetailPengembalian::class, 'id_pengembalian');
    }

   
}
