<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Validator;
use App\Models\User;
use Auth;
//use Laravel\Passport\Passport;
//use Carbon\Carbon;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Cache;





class UsersController extends Controller
{
    //



    public function login_sanctum(Request $request)
                {
                        $user = User::where('email', $request->email)->first();




                        if (!Auth::attempt(['email' => $request->email, 'password' => $request->password])){
                      //   if (!$user || !Hash::check($request->password, $user->password)) {

                                return response()
                                    ->json(['message' => '404'], 401);
                            }

                        $token['token'] = $user->createToken('my-app-token')->plainTextToken;

                          return response()->json([
                          'success' => true,
                          'token' => $token,
                          'user' => $user,

                      ]);




                }

    public function register(Request $request)
  {
      $validator = Validator::make($request->all(), [
          'name' => 'required',
          //'lname' => 'required',
         // 'phone' => 'required|unique:users|regex:/(0)[0-9]{10}/',
          'email' => 'required|email|unique:users',
          'password' => 'required',
           'level' => 'required',
      ]);
      if ($validator->fails()) {
        return response()->json([
          'success' => false,
          'message' => $validator->errors(),
        ], 401);
      }
      $input = $request->all();
      $input['password'] = bcrypt($input['password']);
      $user = User::create($input);
      $success['token'] = $user->createToken('appToken')->accessToken;
      return response()->json([
        'success' => true,
        'token' => $success,
        'user' => $user
    ]);
  }


   public function userList()
    {

        $user = User::select('name')->get();

        echo json_encode($user);
    }


  public function logout(Request $res)
    {


       auth()->logout();
      return response()->json([
          'success'    => true,
          'message' => 'Logout successfully'
      ]);
     }


  public function sendOtp(Request $request)
  {
      $request->validate([
        'email' => 'required|email',
    ]);

    $otp = rand(100000, 999999);
    $email = $request->email;

    // Simpan OTP sementara (5 menit)
    Cache::put('otp_' . $email, $otp, now()->addMinutes(5));

    // Kirim email
    Mail::raw("Kode OTP kamu adalah: $otp", function ($message) use ($email) {
        $message->to($email)
                ->subject('Kode OTP Anda');
    });

    return response()->json(['success' => true]);
  }

  public function verifyOtp(Request $request)
  {


    $request->validate([
        'email' => 'required|email',
        'otp' => 'required|numeric',
      ]);

      $storedOtp = Cache::get('otp_' . $request->email);

      if ($storedOtp == $request->otp) {

        $validator = Validator::make($request->all(), [
            'email' => 'required|email|unique:users',
            'password' => 'required',
        ]);
        if ($validator->fails()) {
          return response()->json([
            'success' => false,
            'message' => $validator->errors(),
          ], 401);
        }
        $input = $request->all();

        $user = User::insert([
            'email' => $request->email,
            'name' => $request->nama,           
            'password' => bcrypt($request->password),
            

        ]);


        return response()->json(['success' => true, 'message' => 'OTP Benar','data' => $request->all()],200);
      } else {
          return response()->json(['success' => false, 'message' => 'OTP salah','storedOtp' => $storedOtp], 400);
      }
  }
}
